//
//  MyViewController.m
//  HelloWorld
//
//  Created by owen osborn on 1/14/09.
//  Copyright 2009 __Zivtech__. All rights reserved.
//

#import "MyViewController.h"

@implementation MyViewController

@synthesize textViewTitle;
@synthesize textViewBody;

// this exits the keyboard view when return key is pressed
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
	if ([text isEqualToString:@"\n"]) {
		[textView resignFirstResponder];
		return NO;
	}
	return YES;
}

// erase contents when text field is touched
- (void)textViewDidBeginEditing:(UITextView *)textView {
	textView.text = @"";
}

// when submit is pressed
- (IBAction)changeGreeting:(id)sender {
	
	// get title and body from the text fields
    NSString *titleString = textViewTitle.text;
	NSString *bodyString = textViewBody.text;
	
	// this commented section prepares an XML-RPC request by adding XML directly to the body of an HTTP POST request
	/*NSString *requestString = [[NSString alloc] initWithFormat:@"<methodCall>"
							   "<methodName>node.save</methodName>"
							   "<params>"
							   "<param><value><struct>"
							   "  <member><name>type</name><value><string>story</string></value></member>"
							   "  <member><name>title</name><value><string>%@</string></value></member>"
							   "  <member><name>body</name><value><string>%@</string></value></member>"
							   "</struct></value></param>"
							   "</params></methodCall>", titleString, bodyString];
	
	NSData *requestData = [NSData dataWithBytes: [requestString UTF8String] length: [requestString length]];
	NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL: [NSURL URLWithString: @"http://192.168.1.14/drupal-6.6/services/xmlrpc"]];
	
	[request setHTTPMethod: @"POST"];
	[request setHTTPBody: requestData];
	
	NSData *returnData = [ NSURLConnection sendSynchronousRequest: request returningResponse: nil error: nil ];
	NSString *returnString = [[NSString alloc] initWithData:returnData encoding: NSUTF8StringEncoding];
	
	// display XML-RPC result
	textViewBody.text = returnString;*/
	
	// create and execute XML-RPC request
    XMLRPCRequest *request = [[XMLRPCRequest alloc] initWithHost:[NSURL URLWithString: @"http://192.168.1.14/drupal-6.6/services/xmlrpc"]];
	NSMutableDictionary *postParams = [NSMutableDictionary dictionary];
	[postParams setObject:@"story" forKey:@"type"];     
	[postParams setObject:titleString forKey:@"title"];  // title input from iphone
	[postParams setObject:bodyString forKey:@"body"];    // body input from iphone
	[request setMethod:@"node.save" withObject:postParams];
	XMLRPCResponse *nodeSaveResponse = [XMLRPCConnection sendSynchronousXMLRPCRequest:request];
	
	// print response
	textViewBody.text = [nodeSaveResponse source];

    [request release];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning]; // Releases the view if it doesn't have a superview
    // Release anything that's not essential, such as cached data
}


- (void)dealloc {
	
	[textViewTitle release];
    [textViewBody release];

    [super dealloc];
}


@end
